(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["simple-aggrid-table"],{

/***/ "./assets/js/simple-aggrid-table.js":
/*!******************************************!*\
  !*** ./assets/js/simple-aggrid-table.js ***!
  \******************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function($) {/* harmony import */ var _xls_export_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./xls-export.js */ "./assets/js/xls-export.js");
var _window$props, _window$props2;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (_i = _i.call(arr), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }



var agGrid = __webpack_require__(/*! ./ag-grid-community.js */ "./assets/js/ag-grid-community.js");

tableData['columns'][1].headerClass = 'pl-30';
tableData['columns'] = tableData['columns'].map(function (col) {
  if (window.location.pathname !== "/grd/") {
    col.cellClass += " responsiveCell";
  }

  if (window.matchMedia('(max-device-width: 600px)').matches) {
    col.wrapText = true;
    col.hide = col.hideOnMobile;

    if (true === (col === null || col === void 0 ? void 0 : col.checkboxSelectionOnMobile)) {
      col.checkboxSelection = true;
    }

    if ("id" == col.field) {
      col.minWidth = 200;
      col.flex = 1;
    }
  }

  if (col.statusClass) {
    col.cellClass = function (params) {
      return params.data.statusClass;
    };
  }

  if ("deadline" == col.field) {
    col.valueFormatter = dateFormatter;
    col.comparator = dateComparator;
  }

  return col;
});

function dateFormatter(params) {
  if ("" === params.value || null === params.value || undefined == params.value) {
    return "ASD";
  }

  var dateAsString = params.data.deadline;
  var dateParts = dateAsString.split('/');
  return "".concat(dateParts[0], "/").concat(dateParts[1], "/").concat(dateParts[2]);
} // DATE COMPARATOR FOR SORTING


function dateComparator(date1, date2) {
  var date1Number = _monthToNum(date1);

  var date2Number = _monthToNum(date2);

  if (date1Number === null && date2Number === null) {
    return 0;
  }

  if (date1Number === null) {
    return -1;
  }

  if (date2Number === null) {
    return 1;
  }

  return date1Number - date2Number;
} // HELPER FOR DATE COMPARISON


function _monthToNum(date) {
  if (date === undefined || date === null || date.length !== 10) {
    return null;
  }

  var yearNumber = date.substring(6, 10);
  var monthNumber = date.substring(3, 5);
  var dayNumber = date.substring(0, 2);
  var result = yearNumber * 10000 + monthNumber * 100 + dayNumber; // 29/08/2004 => 20040829

  return result;
}

function onRowSelected(event) {
  if (window.location.pathname == "/grd/") {
    var allNodes = gridOptions.gridOptions.api.getSelectedNodes();
    var notifyBlock = false;
    var deleteBlock = false;

    var _iterator = _createForOfIteratorHelper(allNodes.entries()),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var _node$data;

        var _step$value = _slicedToArray(_step.value, 2),
            key = _step$value[0],
            node = _step$value[1];

        if (currentUserId != node.data.user_id) {
          $('#deleteAllSelected').addClass('disabledIcon');
          deleteBlock = true;
        }

        if (true == (node === null || node === void 0 ? void 0 : (_node$data = node.data) === null || _node$data === void 0 ? void 0 : _node$data.isFinished)) {
          $('#grdNotifyUser').addClass('disabledIcon');
          notifyBlock = true;
        }

        if (notifyBlock && deleteBlock) {
          return;
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    if (false == notifyBlock) {
      $('#grdNotifyUser').removeClass('disabledIcon');
    }

    if (false == deleteBlock) {
      $('#deleteAllSelected').removeClass('disabledIcon');
    }
  }

  if (window.location.pathname == "/pdp/") {
    var _allNodes = gridOptions.gridOptions.api.getSelectedNodes();

    var _deleteBlock = false;

    var _iterator2 = _createForOfIteratorHelper(_allNodes.entries()),
        _step2;

    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var _step2$value = _slicedToArray(_step2.value, 2),
            _key = _step2$value[0],
            _node = _step2$value[1];

        if (currentUserId != _node.data.ownerId) {
          $('#exportCronData').addClass('disabledIcon');
          _deleteBlock = true;
        }
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }

    if (false == _deleteBlock) {
      $('#exportCronData').removeClass('disabledIcon');
    }
  }
}

var gridOptions = {
  rowData: tableData['rows'],
  columnDefs: tableData['columns'],
  rowHeight: window.matchMedia('(max-device-width: 600px)').matches ? 150 : 40,
  pagination: window.matchMedia('(max-device-width: 600px)').matches || (_window$props = window.props) !== null && _window$props !== void 0 && _window$props.noPagination ? false : true,
  paginationPageSize: window.matchMedia('(max-device-width: 600px)').matches || (_window$props2 = window.props) !== null && _window$props2 !== void 0 && _window$props2.noPagination ? 10000 : 10,
  suppressPaginationPanel: true,
  rowMultiSelectWithClick: true,
  animateRows: true,
  onSelectionChanged: onRowSelected,
  defaultColDef: {
    sortable: true,
    filter: 'agTextColumnFilter'
  },
  rowSelection: 'multiple',
  onRowClicked: function onRowClicked(event) {
    if (window.location.pathname == "/initiatives/panel") {
      window.location.href = '/initiatives/' + event.data.id + '/edit';
    } else if (window.location.pathname == "/grd/") {
      window.location.href = window.location.pathname + event.data.id + '/edit';
    } else if (window.location.pathname == "/pdp/") {
      window.location.href = window.location.origin + '/pdp/' + event.data.id + '/edit';
    } else if (window.location.pathname.includes("/pdp/") && window.location.pathname.includes("/scheme")) {
      window.location.href = window.location.origin + window.location.pathname + event.data.id + '/edit';
    } else if (window.location.pathname != "/logs/") {
      window.location.href = window.location.href + event.data.id + '/edit';
    }
  },
  getRowStyle: function getRowStyle() {
    var style = {
      fontWeight: 400,
      color: '#525F7F',
      fontSize: '14px',
      borderRadius: '4px'
    };
    return style;
  },
  onGridReady: function onGridReady(event) {
    autoSizeAll();
    var total = event.api.paginationGetTotalPages();

    if (total === 0) {
      $('#totalPage').text('1');
    } else {
      $('#totalPage').text(total);
    }

    $('#currentPage').html(event.api.paginationGetCurrentPage() + 1);
    $('.disableCheckbox').find("input.ag-checkbox-input").prop("disabled", true);
  }
};

if (window.location.pathname == "/grd/") {
  gridOptions.domLayout = 'autoHeight';
}

function autoSizeAll() {
  var allColumnIds = [];
  gridOptions.gridOptions.columnApi.getAllColumns().forEach(function (column) {
    allColumnIds.push(column.colId);
  });
  gridOptions.gridOptions.columnApi.autoSizeColumns(allColumnIds);
} // Get the table's div


var eGridDiv = document.querySelector('#aggridTableWrapper'); // Create the table

gridOptions = new agGrid.Grid(eGridDiv, gridOptions);
$('#selectAllAggridCheckbox').on('change', function (e) {
  if (e.currentTarget.checked) {
    gridOptions.gridOptions.api.selectAll();
  } else {
    gridOptions.gridOptions.api.deselectAll();
  }
});
$('#fininshAllSelected').on('click', function (e) {
  var pdp_finished = $(e.target).data("pdp-finished") == '1';

  if (pdp_finished) {
    alertPdpFinished();
    return;
  }

  var allNodes = gridOptions.gridOptions.api.getSelectedNodes();

  if (allNodes.length > 0) {
    cuteAlert({
      type: "question",
      title: "Concluir",
      message: "Você tem certeza que deseja concluir " + allNodes.length + " ações?",
      confirmText: "Sim",
      cancelText: "Não"
    }).then(function (e) {
      var allIds = [];
      allNodes.forEach(function (node) {
        allIds.push(node.data.id);
      });

      if (e == "confirm") {
        $.ajax({
          type: 'post',
          url: window.location.pathname + 'fininsh_ids',
          data: {
            allIds: allIds
          },
          complete: function complete(res) {
            location.reload();
          }
        });
      }
    });
  } else {
    cuteToast({
      type: "error",
      message: "Você precisa selecionar pelo menos uma linha para concluir."
    });
  }
});

function alertPdpFinished() {
  cuteAlert({
    type: "info",
    title: "Projeto finalizado",
    message: "O projeto já foi finalizado e está bloqueado para alterações"
  });
}

$('#pdpNotifyUser').on('click', function (e) {
  var pdp_finished = $(e.target).data("pdp-finished") == '1';

  if (pdp_finished) {
    alertPdpFinished();
    return;
  }

  var allNodes = gridOptions.gridOptions.api.getSelectedNodes();

  if (allNodes.length > 0) {
    cuteAlert({
      type: "question",
      title: "Concluir",
      message: "Você tem certeza que deseja notificar " + allNodes.length + " usuários?",
      confirmText: "Sim",
      cancelText: "Não"
    }).then(function (e) {
      var allIds = [];
      allNodes.forEach(function (node) {
        allIds.push(node.data.id);
      });

      if (e == "confirm") {
        $.ajax({
          type: 'post',
          url: window.location.href + 'notify-task-user',
          data: {
            allIds: allIds
          },
          complete: function complete(res) {
            location.reload();
          }
        });
      }
    });
  } else {
    cuteToast({
      type: "error",
      message: "Você precisa selecionar pelo menos uma linha para concluir."
    });
  }
});
$('#grdNotifyUser').on('click', function (e) {
  var allNodes = gridOptions.gridOptions.api.getSelectedNodes();

  if (allNodes.length > 0) {
    cuteAlert({
      type: "question",
      title: "Concluir",
      message: "Você tem certeza que deseja notificar " + allNodes.length + " usuários?",
      confirmText: "Sim",
      cancelText: "Não"
    }).then(function (e) {
      var allIds = [];
      allNodes.forEach(function (node) {
        allIds.push(node.data.id);
      });

      if (e == "confirm") {
        $.ajax({
          type: 'post',
          url: window.location.href + 'notify-task-user',
          data: {
            allIds: allIds
          },
          complete: function complete(res) {
            if (true === res.responseJSON.success) {
              cuteToast({
                type: "success",
                message: "Usuários notificados com sucesso."
              });
            } else {
              cuteToast({
                type: "error",
                message: "Ocorreu um erro ao notificar os usuários."
              });
            }
          }
        });
      }
    });
  } else {
    cuteToast({
      type: "error",
      message: "Você precisa selecionar pelo menos uma linha para concluir."
    });
  }
});
$('#deleteAllSelected').on('click', function (e) {
  var pdp_finished = $(e.target).data("pdp-finished") == '1';

  if (pdp_finished) {
    alertPdpFinished();
    return;
  }

  var pathname = window.location.pathname;

  if (pathname == "/grd/") {
    var _allNodes2 = gridOptions.gridOptions.api.getSelectedNodes();

    var _iterator3 = _createForOfIteratorHelper(_allNodes2.entries()),
        _step3;

    try {
      for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
        var _step3$value = _slicedToArray(_step3.value, 2),
            key = _step3$value[0],
            node = _step3$value[1];

        if (currentUserId != node.data.user_id) {
          $('#deleteAllSelected').addClass('disabledIcon');
          cuteToast({
            type: "error",
            message: "Você só pode deletar suas próprias ações."
          });
          return false;
        }
      }
    } catch (err) {
      _iterator3.e(err);
    } finally {
      _iterator3.f();
    }
  }

  var allNodes = gridOptions.gridOptions.api.getSelectedNodes();

  if (allNodes.length > 0) {
    cuteAlert({
      type: "question",
      title: "Deletar",
      message: "Você tem certeza que deseja deletar " + allNodes.length + " linhas?",
      confirmText: "Sim",
      cancelText: "Não"
    }).then(function (e) {
      var allIds = [];
      allNodes.forEach(function (node) {
        allIds.push(node.data.id);
      });

      if (e == "confirm") {
        var url;

        if (window.location.pathname.includes('initiatives')) {
          url = '/initiatives/delete_ids';
        } else {
          url = pathname + 'delete_ids';
        }

        $.ajax({
          type: 'post',
          url: url,
          data: {
            allIds: allIds
          },
          complete: function complete(res) {
            location.reload();
          }
        });
      }
    });
  } else {
    cuteToast({
      type: "error",
      message: "Você precisa selecionar pelo menos uma linha para excluir."
    });
  }
});
$('#cloneData').on('click', function (e) {
  var allNodes = gridOptions.gridOptions.api.getSelectedNodes();

  if (allNodes.length !== 1) {
    cuteToast({
      type: "error",
      message: "Você precisa selecionar somente um projeto para clonar."
    });
  } else {
    cuteAlert({
      type: "question",
      title: "Clonar",
      message: "Você tem certeza que deseja clonar este projeto?",
      confirmText: "Sim",
      cancelText: "Não"
    }).then(function (e) {
      if (e == "confirm") {
        var url = window.location.pathname + 'clone';
        $.ajax({
          type: 'post',
          url: url,
          data: {
            cloneId: allNodes[0].data.id
          },
          complete: function complete(res) {
            location.reload();
          }
        });
      }
    });
  }
});
$('#exportData').on('click', function (e) {
  var allRows = JSON.parse(JSON.stringify(gridOptions.gridOptions.rowData));

  var _iterator4 = _createForOfIteratorHelper(allRows),
      _step4;

  try {
    for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
      var node = _step4.value;
      delete node['user_id'];
    }
  } catch (err) {
    _iterator4.e(err);
  } finally {
    _iterator4.f();
  }

  allRows = JSON.stringify(allRows);
  gridOptions.gridOptions.api.getColumnDefs().map(function (col) {
    allRows = allRows.replaceAll(col.field, col.headerName);
  });
  var xlsConvert = new _xls_export_js__WEBPACK_IMPORTED_MODULE_0__["default"](JSON.parse(allRows), 'tabela');
  xlsConvert.exportToXLS('tabela.xls');
  gridOptions.gridOptions.api.deselectAll();
});
$('#exportCronData').on('click', function (e) {
  var allRows = JSON.parse(JSON.stringify(pdpTasksData));
  var allNodes = gridOptions.gridOptions.api.getSelectedNodes();
  var allIds = [];
  allNodes.forEach(function (node) {
    allIds.push(node.data.id);
  });
  var exportRows = [];
  allRows.forEach(function (row) {
    if (allIds.includes(row.IdPDP)) {
      exportRows.push(row);
    }
  });
  var xlsConvert = new _xls_export_js__WEBPACK_IMPORTED_MODULE_0__["default"](exportRows, 'tabela');
  xlsConvert.exportToXLS('tabela.xls');
  gridOptions.gridOptions.api.deselectAll();
});
$('#finishPlanData').on('click', function (e) {
  var allNodes = gridOptions.gridOptions.api.getSelectedNodes();

  if (allNodes.length > 0) {
    var allIds = [];
    allNodes.forEach(function (node) {
      allIds.push(node.data.id);
    });
    $.ajax({
      type: 'post',
      url: window.location.href + 'toggle_finished',
      data: {
        allIds: allIds
      },
      complete: function complete(res) {
        location.reload();
      }
    });
  }
});
$('#inputSearchTable').on('input', function (e) {
  var attr = $(e.currentTarget).data('attr-search') || 'name';

  var filter = _defineProperty({}, attr, {
    type: 'contains',
    filter: e.currentTarget.value,
    filterType: "text"
  });

  console.log(filter);
  gridOptions.gridOptions.api.setFilterModel(filter);
});
$('#clearFilters').on('click', function () {
  gridOptions.gridOptions.api.setFilterModel(null);
  $('.inputSearchTable').val('');
  $('#inputSearchTable').val('');
});
$('.inputSearchTable').on('input', function (e) {
  var model = gridOptions.gridOptions.api.getFilterModel();
  var attr = $(e.currentTarget).data('attr-search') || 'name';
  model[attr] = {
    type: 'contains',
    filter: e.currentTarget.value,
    filterType: "text"
  };
  gridOptions.gridOptions.api.setFilterModel(model);
});
$('#inputFilterPeriod').on('change', function (e) {
  var filter = {
    mensuration: {
      type: 'contains',
      filter: e.currentTarget.value,
      filterType: "text"
    }
  };
  gridOptions.gridOptions.api.setFilterModel(filter);
});
$('#inputFilterGoalPeriod').on('change', function (e) {
  var filter = {
    goal_period: {
      type: 'contains',
      filter: e.currentTarget.value,
      filterType: "text"
    }
  };
  gridOptions.gridOptions.api.setFilterModel(filter);
});
$('.leftArrowIcon').on('click', function () {
  gridOptions.gridOptions.api.paginationGoToPreviousPage();
  $('#currentPage').html(gridOptions.gridOptions.api.paginationGetCurrentPage() + 1);
});
$('.rightArrowIcon').on('click', function () {
  gridOptions.gridOptions.api.paginationGoToNextPage();
  $('#currentPage').html(gridOptions.gridOptions.api.paginationGetCurrentPage() + 1);
});
$('#printAllSelected').on('click', function (e) {
  var allNodes = gridOptions.gridOptions.api.getSelectedNodes();

  if (allNodes.length === 0) {
    cuteToast({
      type: "error",
      message: "Você precisa selecionar uma TNC para impressão."
    });
    SettingsBackupRestoreOutlined;
  }

  if (allNodes.length > 1) {
    cuteToast({
      type: "error",
      message: "Você precisa selecionar apenas uma TNC para impressão."
    });
    return;
  }

  allNodes.forEach(function (node) {
    window.open("".concat(window.location).concat(node.data.id, "/print"));
  });
});

function cuteAlert(_ref) {
  var type = _ref.type,
      title = _ref.title,
      message = _ref.message,
      _ref$buttonText = _ref.buttonText,
      buttonText = _ref$buttonText === void 0 ? "OK" : _ref$buttonText,
      _ref$confirmText = _ref.confirmText,
      confirmText = _ref$confirmText === void 0 ? "OK" : _ref$confirmText,
      _ref$cancelText = _ref.cancelText,
      cancelText = _ref$cancelText === void 0 ? "Cancel" : _ref$cancelText,
      closeStyle = _ref.closeStyle;
  return new Promise(function (resolve) {
    setInterval(function () {}, 5000);
    var body = document.querySelector("body");
    var scripts = document.getElementsByTagName("script");
    var currScript = "";

    var _iterator5 = _createForOfIteratorHelper(scripts),
        _step5;

    try {
      for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
        var script = _step5.value;

        if (script.src.includes("simple-aggrid-table.js")) {
          currScript = script;
        }
      }
    } catch (err) {
      _iterator5.e(err);
    } finally {
      _iterator5.f();
    }

    var src = currScript.src;
    src = !src ? '/build' : src.substring(0, src.lastIndexOf("/"));
    var closeStyleTemplate = "alert-close";

    if (closeStyle === "circle") {
      closeStyleTemplate = "alert-close-circle";
    }

    var btnTemplate = "\n\t  <button class=\"alert-button ".concat(type, "-bg ").concat(type, "-btn\">").concat(buttonText, "</button>\n\t  ");

    if (type === "question") {
      btnTemplate = "\n\t\t<div class=\"question-buttons\">\n\t\t  <button class=\"confirm-button ".concat(type, "-bg ").concat(type, "-btn\">").concat(confirmText, "</button>\n\t\t  <button class=\"cancel-button error-bg error-btn\">").concat(cancelText, "</button>\n\t\t</div>\n\t\t");
    }

    var template = "\n\t  <div class=\"alert-wrapper\">\n\t\t<div class=\"alert-frame\">\n\t\t  <div class=\"alert-header ".concat(type, "-bg\">\n\t\t\t<span class=\"").concat(closeStyleTemplate, "\">X</span>\n\t\t\t<img class=\"alert-img\" src=\"").concat(src, "/images/").concat(type, ".svg\" />\n\t\t  </div>\n\t\t  <div class=\"alert-body\">\n\t\t\t<span class=\"alert-title\">").concat(title, "</span>\n\t\t\t<span class=\"alert-message\">").concat(message, "</span>\n\t\t\t").concat(btnTemplate, "\n\t\t  </div>\n\t\t</div>\n\t  </div>\n\t  ");
    body.insertAdjacentHTML("afterend", template);
    var alertWrapper = document.querySelector(".alert-wrapper");
    var alertFrame = document.querySelector(".alert-frame");
    var alertClose = document.querySelector(".".concat(closeStyleTemplate));

    if (type === "question") {
      var confirmButton = document.querySelector(".confirm-button");
      var cancelButton = document.querySelector(".cancel-button");
      confirmButton.addEventListener("click", function () {
        alertWrapper.remove();
        resolve("confirm");
      });
      cancelButton.addEventListener("click", function () {
        alertWrapper.remove();
        resolve();
      });
    } else {
      var alertButton = document.querySelector(".alert-button");
      alertButton.addEventListener("click", function () {
        alertWrapper.remove();
        resolve();
      });
    }

    alertClose.addEventListener("click", function () {
      alertWrapper.remove();
      resolve();
    });
    alertWrapper.addEventListener("click", function () {
      alertWrapper.remove();
      resolve();
    });
    alertFrame.addEventListener("click", function (e) {
      e.stopPropagation();
    });
  });
}

function cuteToast(_ref2) {
  var type = _ref2.type,
      message = _ref2.message,
      _ref2$timer = _ref2.timer,
      timer = _ref2$timer === void 0 ? 5000 : _ref2$timer;
  return new Promise(function (resolve) {
    if (document.querySelector(".toast-container")) {
      document.querySelector(".toast-container").remove();
    }

    var body = document.querySelector("body");
    var scripts = document.getElementsByTagName("script");
    var currScript = "";

    var _iterator6 = _createForOfIteratorHelper(scripts),
        _step6;

    try {
      for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
        var script = _step6.value;

        if (script.src.includes("simple-aggrid-table.js")) {
          currScript = script;
        }
      }
    } catch (err) {
      _iterator6.e(err);
    } finally {
      _iterator6.f();
    }

    var src = currScript.src;
    src = !src ? '/build' : src.substring(0, src.lastIndexOf("/"));
    var template = "\n\t\t<div class=\"toast-container ".concat(type, "-bg\">\n\t\t\t<div>\n\t\t\t\t<div class=\"toast-frame\">\n\t\t\t\t<img class=\"toast-img\" src=\"").concat(src, "/images/").concat(type, ".svg\" />\n\t\t\t\t<span class=\"toast-message\">").concat(message, "</span>\n\t\t\t\t<div class=\"toast-close\">X</div>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"toast-timer ").concat(type, "-timer\" style=\"animation: timer ").concat(timer, "ms linear;\"/>\n\t\t\t</div>\n\t\t</div>\n\t\t");
    body.insertAdjacentHTML("afterend", template);
    var toastContainer = document.querySelector(".toast-container");
    setTimeout(function () {
      toastContainer.remove();
      resolve();
    }, timer);
    var toastClose = document.querySelector(".toast-close");
    toastClose.addEventListener("click", function () {
      toastContainer.remove();
      resolve();
    });
  });
}
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./assets/js/xls-export.js":
/*!*********************************!*\
  !*** ./assets/js/xls-export.js ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * __  ___     _____                       _
 * \ \/ / |___| ____|_  ___ __   ___  _ __| |_
 *  \  /| / __|  _| \ \/ / '_ \ / _ \| '__| __|
 *  /  \| \__ \ |___ >  <| |_) | (_) | |  | |_
 * /_/\_\_|___/_____/_/\_\ .__/ \___/|_|   \__|
 *                       |_|
 * 6/12/2017
 * Daniel Blanco Parla
 * https://github.com/deblanco/xlsExport
 */
var XlsExport = /*#__PURE__*/function () {
  // data: array of objects with the data for each row of the table
  // name: title for the worksheet
  function XlsExport(data) {
    var title = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'Worksheet';

    _classCallCheck(this, XlsExport);

    // input validation: new xlsExport([], String)
    if (!Array.isArray(data) || typeof title !== 'string' || Object.prototype.toString.call(title) !== '[object String]') {
      throw new Error('Invalid input types: new xlsExport(Array [], String)');
    }

    this._data = data;
    this._title = title;
  }

  _createClass(XlsExport, [{
    key: "setData",
    set: function set(data) {
      if (!Array.isArray(data)) throw new Error('Invalid input type: setData(Array [])');
      this._data = data;
    }
  }, {
    key: "getData",
    get: function get() {
      return this._data;
    }
  }, {
    key: "exportToXLS",
    value: function exportToXLS() {
      var fileName = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'export.xls';

      if (typeof fileName !== 'string' || Object.prototype.toString.call(fileName) !== '[object String]') {
        throw new Error('Invalid input type: exportToCSV(String)');
      }

      var TEMPLATE_XLS = "\n        <html xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:x=\"urn:schemas-microsoft-com:office:excel\" xmlns=\"http://www.w3.org/TR/REC-html40\">\n        <meta http-equiv=\"content-type\" content=\"application/vnd.ms-excel; charset=UTF-8\"/>\n        <head><!--[if gte mso 9]><xml>\n        <x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{title}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml>\n        <![endif]--></head>\n        <body>{table}</body></html>";
      var MIME_XLS = 'application/vnd.ms-excel;base64,';
      var parameters = {
        title: this._title,
        table: this.objectToTable()
      };
      var computeOutput = TEMPLATE_XLS.replace(/{(\w+)}/g, function (x, y) {
        return parameters[y];
      });
      var computedXLS = new Blob([computeOutput], {
        type: MIME_XLS
      });
      var xlsLink = window.URL.createObjectURL(computedXLS);
      this.downloadFile(xlsLink, fileName);
    }
  }, {
    key: "exportToCSV",
    value: function exportToCSV() {
      var fileName = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'export.csv';

      if (typeof fileName !== 'string' || Object.prototype.toString.call(fileName) !== '[object String]') {
        throw new Error('Invalid input type: exportToCSV(String)');
      }

      var computedCSV = new Blob([this.objectToSemicolons()], {
        type: 'text/csv;charset=utf-8'
      });
      var csvLink = window.URL.createObjectURL(computedCSV);
      this.downloadFile(csvLink, fileName);
    }
  }, {
    key: "downloadFile",
    value: function downloadFile(output, fileName) {
      var link = document.createElement('a');
      document.body.appendChild(link);
      link.download = fileName;
      link.href = output;
      link.click();
    }
  }, {
    key: "toBase64",
    value: function toBase64(string) {
      return window.btoa(unescape(encodeURIComponent(string)));
    }
  }, {
    key: "objectToTable",
    value: function objectToTable() {
      // extract keys from the first object, will be the title for each column
      var colsHead = "<tr>".concat(Object.keys(this._data[0]).map(function (key) {
        return "<td>".concat(key, "</td>");
      }).join(''), "</tr>");

      var colsData = this._data.map(function (obj) {
        return ["<tr>\n                ".concat(Object.keys(obj).map(function (col) {
          return "<td>".concat(obj[col] ? obj[col] : '', "</td>");
        }).join(''), "\n            </tr>")];
      }) // 'null' values not showed
      .join('');

      return "<table>".concat(colsHead).concat(colsData, "</table>").trim(); // remove spaces...
    }
  }, {
    key: "objectToSemicolons",
    value: function objectToSemicolons() {
      var colsHead = Object.keys(this._data[0]).map(function (key) {
        return [key];
      }).join(';');

      var colsData = this._data.map(function (obj) {
        return [// obj === row
        Object.keys(obj).map(function (col) {
          return [obj[col] // row[column]
          ];
        }).join(';') // join the row with ';'
        ];
      }).join('\n'); // end of row


      return "".concat(colsHead, "\n").concat(colsData);
    }
  }]);

  return XlsExport;
}();

/* harmony default export */ __webpack_exports__["default"] = (XlsExport); // comment this line to babelize

/***/ })

},[["./assets/js/simple-aggrid-table.js","runtime","vendors~app~co~doi_form~financial_form~grd-dashboard~img-dropzone~jquery-mask~jquery-money-mask~menu~40356eb1","co~mokpi-aggrid-table~simple-aggrid-table~tqm"]]]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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