(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["mokpi-dashboard"],{

/***/ "./assets/js/mokpi-dashboard.js":
/*!**************************************!*\
  !*** ./assets/js/mokpi-dashboard.js ***!
  \**************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function($) {/* harmony import */ var _apexcharts_min_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./apexcharts.min.js */ "./assets/js/apexcharts.min.js");
/* harmony import */ var _apexcharts_min_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_apexcharts_min_js__WEBPACK_IMPORTED_MODULE_0__);


if ("inteiro" != mensuration) {
  for (var key in mokpiValues) {
    mokpiValues[key] = String(mokpiValues[key]).replaceAll(",", ".");
  }

  for (var _key in mokpiGoalChartData) {
    mokpiGoalChartData[_key] = String(mokpiGoalChartData[_key]).replaceAll(",", ".");
  }

  for (var _key2 in mokpiBaseChartData) {
    mokpiBaseChartData[_key2] = String(mokpiBaseChartData[_key2]).replaceAll(",", ".");
  }
}

var options = {
  series: [{
    name: 'MOKPI',
    type: 'bar',
    data: mokpiValues
  }, {
    name: 'Meta',
    type: 'line',
    data: mokpiGoalChartData
  }, {
    name: 'Base',
    type: 'line',
    data: mokpiBaseChartData
  }],
  colors: ['#FF5800', '#3C69A3', '#3CA372'],
  chart: {
    width: '100%'
  },
  plotOptions: {
    bar: {
      horizontal: false,
      columnWidth: '55%',
      endingShape: 'rounded',
      dataLabels: {
        position: 'top' // top, center, bottom

      }
    }
  },
  dataLabels: {
    enabled: true,
    enabledOnSeries: [0],
    formatter: function formatter(val) {
      val = getFormattedValue(val);

      if ("moeda" == mensuration) {
        return "R$ " + val;
      } else if ("percentual" == mensuration) {
        return val + "%";
      } else {
        return val;
      }
    },
    style: {
      fontSize: '12px'
    }
  },
  stroke: {
    show: true,
    width: [0, 3, 3]
  },
  xaxis: {
    categories: ['JAN', 'FEV', 'MAR', 'ABR', 'MAI', 'JUN', 'JUL', 'AGO', 'SET', 'OUT', 'NOV', 'DEZ']
  },
  yaxis: {
    labels: {
      formatter: function formatter(val) {
        return getFormattedValue(val);
      }
    }
  }
};
var chartCol = new _apexcharts_min_js__WEBPACK_IMPORTED_MODULE_0___default.a(document.querySelector("#mokpiChart"), options);
chartCol.render();
$('#mokpiFilter').on('change', function (e) {
  var urlParams = new URLSearchParams(window.location.search);
  urlParams.set('mokpi', $('#mokpiFilter').val());
  urlParams.set('year', $('#yearFilter').val());
  window.location.search = urlParams;
});
$('#yearFilter').on('change', function (e) {
  var urlParams = new URLSearchParams(window.location.search);
  urlParams.set('mokpi', $('#mokpiFilter').val());
  urlParams.set('year', $('#yearFilter').val());
  window.location.search = urlParams;
});

function getFormattedValue() {
  var value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
  var decimals_cases = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
  var inputFormat = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

  if (null == value || isNaN(value) || value == '') {
    return value;
  } else {
    var negative;

    if (value < 0) {
      negative = "-";
    } else {
      negative = "";
    }

    return formatDecimalNumber(value, decimals_cases, inputFormat, negative);
  }
}

function formatDecimalNumber(value, decimals_cases, inputFormat, negative) {
  value = value.toString(); // Divide the number and the decimal part
  // The first index is going to be the whole number and the second index is going to be the decimal number if it exists

  var wholeAndDecimalNumber = value.split(".");

  if (wholeAndDecimalNumber[1] !== 'undefined') {
    // If the decimal part doesnt exist set it to zero
    wholeAndDecimalNumber.push(0);
  } // Format the number dividing it by points and comma for decimals


  wholeAndDecimalNumber[0] = number_format(parseFloat(wholeAndDecimalNumber[0]), decimals_cases, inputFormat ? '.' : ',', inputFormat ? false : '.');

  if (0 === decimals_cases) {
    // If there isnt a decimal part return only the int number
    return value.split(inputFormat ? '.' : ',', wholeAndDecimalNumber[0])[0];
  } else {
    // Get the number formated but without the decimal part
    var wholeFormated = wholeAndDecimalNumber[0].split(inputFormat ? '.' : ',');
  } // Set number's decimals case limit


  var decimalLen = wholeAndDecimalNumber[1].length;

  if (decimals_cases > decimalLen) {
    decimals_cases -= decimalLen;
    wholeAndDecimalNumber[1] = number_format(parseFloat(wholeAndDecimalNumber[1]), decimals_cases, '', '');
  } else if (decimals_cases < decimalLen) {
    wholeAndDecimalNumber[1] = wholeAndDecimalNumber[1].substr(0, decimals_cases);
  }

  var decimalDivisor = inputFormat ? '.' : ',';
  value = wholeFormated[0] + decimalDivisor + wholeAndDecimalNumber[1]; // if ( "0,00" == wholeAndDecimalNumber[0] ) {
  //     value = negative + value;
  // }

  return value;
}

function number_format(number, decimals, dec_point, thousands_sep) {
  // Strip all characters but numerical ones.
  number = (number + '').replace(/[^0-9+\-Ee.]/g, '');

  var n = !isFinite(+number) ? 0 : +number,
      prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
      sep = typeof thousands_sep === 'undefined' ? ',' : thousands_sep,
      dec = typeof dec_point === 'undefined' ? '.' : dec_point,
      s = '',
      toFixedFix = function toFixedFix(n, prec) {
    var k = Math.pow(10, prec);
    return '' + Math.round(n * k) / k;
  }; // Fix for IE parseFloat(0.55).toFixed(0) = 0;


  s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');

  if (s[0].length > 3) {
    s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
  }

  if ((s[1] || '').length < prec) {
    s[1] = s[1] || '';
    s[1] += new Array(prec - s[1].length + 1).join('0');
  }

  return s.join(dec);
}
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")))

/***/ })

},[["./assets/js/mokpi-dashboard.js","runtime","vendors~app~co~doi_form~financial_form~grd-dashboard~img-dropzone~jquery-mask~jquery-money-mask~menu~40356eb1","grd-dashboard~mokpi-dashboard~tnc-dashboard"]]]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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