(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["financial_form"],{

/***/ "./assets/js/react/components/FinancialForm.js":
/*!*****************************************************!*\
  !*** ./assets/js/react/components/FinancialForm.js ***!
  \*****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function($) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return FinancialForm; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
/* harmony import */ var _shared_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../shared/styles */ "./assets/js/react/shared/styles.js");
/* harmony import */ var react_currency_format__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-currency-format */ "./node_modules/react-currency-format/lib/currency-format.js");
/* harmony import */ var react_currency_format__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_currency_format__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_datepicker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-datepicker */ "./node_modules/react-datepicker/dist/react-datepicker.min.js");
/* harmony import */ var react_datepicker__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_datepicker__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var date_fns_locale_pt_BR__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! date-fns/locale/pt-BR */ "./node_modules/date-fns/esm/locale/pt-BR/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! moment */ "./node_modules/moment/moment.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _cute_alert_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../cute-alert.js */ "./assets/js/cute-alert.js");
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }









Object(react_datepicker__WEBPACK_IMPORTED_MODULE_4__["registerLocale"])('pt', date_fns_locale_pt_BR__WEBPACK_IMPORTED_MODULE_5__["default"]);


var FinancialForm = /*#__PURE__*/function (_React$Component) {
  _inherits(FinancialForm, _React$Component);

  var _super = _createSuper(FinancialForm);

  function FinancialForm(props) {
    var _this;

    _classCallCheck(this, FinancialForm);

    _this = _super.call(this, props);
    _this.state = window.props.financial || {};
    _this.state.current_user = window.props.current_user;

    if (_this.state.start) {
      _this.state.start = new Date(_this.state.start);
    }

    return _this;
  }

  _createClass(FinancialForm, [{
    key: "handleChange",
    value: function handleChange(attr, event) {
      var value = _typeof(event) === 'object' && event.target ? event.target.value : event;

      if (attr === 'item_type' && value == 3) {
        this.setState({
          cost_reduction_2: '',
          cost_reduction_4: ''
        });
      }

      this.setState(_defineProperty({}, attr, value), this.updateValues.bind(this));
    }
  }, {
    key: "updateValues",
    value: function updateValues() {
      var baseline_1 = this.parseFloat(this.state.baseline_1),
          baseline_2 = this.parseFloat(this.state.baseline_2),
          baseline_3 = this.parseFloat(this.state.baseline_3),
          baseline_4 = this.parseFloat(this.state.baseline_4),
          initiative_1 = this.parseFloat(this.state.initiative_1),
          initiative_2 = this.parseFloat(this.state.initiative_2),
          initiative_3 = this.parseFloat(this.state.initiative_3),
          cost_reduction_1 = this.parseFloat(this.state.cost_reduction_1),
          cost_reduction_2 = this.parseFloat(this.state.cost_reduction_2),
          cost_reduction_3 = this.parseFloat(this.state.cost_reduction_3),
          cost_reduction_4 = this.parseFloat(this.state.cost_reduction_4);

      if (baseline_2 >= baseline_1) {
        cost_reduction_1 = baseline_1 - initiative_1;
        cost_reduction_2 = baseline_2 - initiative_1;
        cost_reduction_3 = cost_reduction_1 * initiative_2;
        cost_reduction_4 = cost_reduction_2 * initiative_2;
      } else {
        cost_reduction_1 = 0;
        cost_reduction_2 = 0;
        cost_reduction_3 = cost_reduction_1 * initiative_2;
        cost_reduction_4 = cost_reduction_2 * initiative_2;
      }

      baseline_4 = baseline_2 * baseline_3;
      initiative_3 = initiative_2 * initiative_1; // if (this.state.item_type === 3) {
      //     cost_reduction_2 = 0;
      //     cost_reduction_4 = 0;
      // }

      this.setState({
        cost_reduction: cost_reduction_3,
        cost_reduction_1: cost_reduction_1,
        cost_reduction_2: cost_reduction_2,
        cost_reduction_3: cost_reduction_3,
        cost_reduction_4: cost_reduction_4,
        baseline_4: baseline_4,
        initiative_3: initiative_3
      });
    }
  }, {
    key: "handleConfirm",
    value: function handleConfirm(item) {
      var _this2 = this;

      Object(_cute_alert_js__WEBPACK_IMPORTED_MODULE_8__["default"])({
        type: 'question',
        title: 'Confirmar datas',
        message: 'Deseja confirmar as datas desta etapa?',
        confirmText: 'Sim',
        cancelText: 'Não'
      });
      setTimeout(function () {
        $('.cute-alert-confirm').off();
        $('.cute-alert-confirm').on('click', _this2.confirm.bind(_this2, item));
      }, 500);
    }
  }, {
    key: "handleRemoveFile",
    value: function handleRemoveFile(file) {
      axios__WEBPACK_IMPORTED_MODULE_6___default()({
        url: "/financial/".concat(this.state.id, "/remove-file?name=").concat(file),
        method: 'POST'
      }).then(function (res) {
        if (res.data.success) {
          Object(_cute_alert_js__WEBPACK_IMPORTED_MODULE_8__["default"])({
            type: 'success',
            title: 'Arquivo removido',
            message: 'Arquivo removido com sucesso!'
          }).then(function () {
            return window.location.reload();
          });
        }
      });
    }
  }, {
    key: "handleSave",
    value: function handleSave() {
      var data = this.state;
      var form_data = new FormData();

      if (data.start) {
        data.start = moment__WEBPACK_IMPORTED_MODULE_7___default()(data.start).format('YYYY-MM-DD [00:00:00]');
      }

      if (data.external_costs && '' != data.external_costs) {
        data.external_costs = this.parseFloat(data.external_costs);
      }

      if (data.internal_costs && '' != data.internal_costs) {
        data.internal_costs = this.parseFloat(data.internal_costs);
      }

      if (data.baseline_1 && '' != data.baseline_1) {
        data.baseline_1 = this.parseFloat(data.baseline_1);
      }

      if (data.baseline_2 && '' != data.baseline_2) {
        data.baseline_2 = this.parseFloat(data.baseline_2);
      }

      if (data.initiative_1 && '' != data.initiative_1) {
        data.initiative_1 = this.parseFloat(data.initiative_1);
      }

      var file = document.querySelector('#financial-file');

      if (file) {
        data.file = file.files[0];
      }

      for (var key in data) {
        form_data.append(key, data[key]);
      }

      axios__WEBPACK_IMPORTED_MODULE_6___default.a.post(window.location.pathname, form_data, {
        headers: {
          'Content-Type': 'multipart/form-data'
        }
      }).then(function (res) {
        if (res.data.success) {
          Object(_cute_alert_js__WEBPACK_IMPORTED_MODULE_8__["default"])({
            type: 'success',
            title: 'Dados salvos',
            message: 'Dados salvos com sucesso!'
          }).then(function () {
            if (res.data.doi_id) {
              window.location.pathname = "/doi/".concat(res.data.doi_id, "/edit");
            } else {
              window.location.reload();
            }
          });
        }
      });
    }
  }, {
    key: "parseFloat",
    value: function parseFloat(value) {
      if (!value || '' == value) {
        return 0;
      } else if (typeof value === 'string') {
        value = value.replaceAll('R$ ', '');
        value = value.replaceAll('.', "");
        value = value.replaceAll(',', ".");
        return Number(value);
      } else {
        return value;
      }
    }
  }, {
    key: "getMoneyInput",
    value: function getMoneyInput(state) {
      var disabled = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_currency_format__WEBPACK_IMPORTED_MODULE_3___default.a, {
        disabled: disabled || state.startsWith('cost_reduction_'),
        placeholder: "R$ 0.00",
        decimalScale: 2,
        fixedDecimalScale: true,
        prefix: 'R$ ',
        className: "form-control",
        value: this.state[state],
        thousandSeparator: ".",
        decimalSeparator: ",",
        onChange: this.handleChange.bind(this, state)
      });
    }
  }, {
    key: "getPercentageInput",
    value: function getPercentageInput(state) {
      var disabled = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_currency_format__WEBPACK_IMPORTED_MODULE_3___default.a, {
        disabled: disabled || state.startsWith('cost_reduction_'),
        placeholder: "0.00%",
        decimalScale: 2,
        fixedDecimalScale: true,
        suffix: '%',
        className: "form-control",
        value: this.state[state],
        onChange: this.handleChange.bind(this, state)
      });
    }
  }, {
    key: "calculateRoi",
    value: function calculateRoi() {
      if (!this.state.external_costs) {
        return 0;
      }

      var divide = this.parseFloat(this.state.external_costs) + this.parseFloat(this.state.internal_costs);
      var netSaving = this.state.cost_reduction - divide;
      return netSaving / divide;
    }
  }, {
    key: "getItemTypeText",
    value: function getItemTypeText() {
      return this.state.item_type == 1 ? 'Material' : this.state.item_type == 2 ? 'Negociação' : this.state.item_type == 3 ? 'Eficiência' : '';
    }
  }, {
    key: "getMoneyText",
    value: function getMoneyText(value) {
      var hide_signal = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      value = this.parseFloat(value);
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_currency_format__WEBPACK_IMPORTED_MODULE_3___default.a, {
        className: "font-gray",
        displayType: 'text',
        placeholder: "R$ 0,00",
        decimalScale: 2,
        thousandSeparator: ".",
        decimalSeparator: ",",
        fixedDecimalScale: true,
        prefix: hide_signal ? '' : 'R$ ',
        value: value
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        container: true,
        className: "px-4 pb-3"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        item: true,
        sm: 12,
        lg: 3
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("label", {
        className: "tqm-label"
      }, "In\xEDcio"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_datepicker__WEBPACK_IMPORTED_MODULE_4___default.a, {
        disabled: true,
        dateFormat: "dd/MM/yyyy",
        className: "form-control",
        locale: date_fns_locale_pt_BR__WEBPACK_IMPORTED_MODULE_5__["default"],
        selected: this.state.start,
        onChange: this.handleChange.bind(this, 'start')
      })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        item: true,
        sm: 12,
        lg: 3,
        className: "pr-5"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("label", {
        className: "tqm-label"
      }, "Redu\xE7\xE3o de custo"), this.getMoneyInput('cost_reduction', true)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        item: true,
        sm: 12,
        lg: 2
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("label", {
        className: "tqm-label pb-2"
      }, "Net savings"), this.getMoneyText(this.parseFloat(this.state.cost_reduction) - (this.parseFloat(this.state.external_costs) + this.parseFloat(this.state.internal_costs)))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        item: true,
        sm: 12,
        lg: 4,
        className: ""
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("label", {
        className: "tqm-label"
      }, "Anexar arquivo"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
        id: "financial-file",
        value: this.state.file,
        type: "file",
        accept: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
        className: "form-control",
        onChange: this.handleChange.bind(this, 'file')
      }), this.state.files && this.state.files.map(function (file) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
          title: "Baixar arquivo",
          className: "d-inline-block mt-1 mr-2 font-14 c-pointer font-dark-blue"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", {
          target: "_blank",
          href: file,
          download: true
        }, file.split('/')[4]), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("i", {
          onClick: _this3.handleRemoveFile.bind(_this3, file),
          title: "Remover",
          className: "fas fa-trash-alt font-red ml-1 font-12 d-inline-block"
        }));
      })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        item: true,
        sm: 12,
        lg: 3,
        className: "mt-3"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("label", {
        className: "tqm-label"
      }, "Per\xEDodo"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("select", {
        value: this.state.period,
        style: {
          width: 80
        },
        className: "form-control",
        onChange: this.handleChange.bind(this, 'period')
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("option", {
        value: "3"
      }, "3"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("option", {
        value: "6"
      }, "6"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("option", {
        value: "12"
      }, "12")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "pr-5 mt-3"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("label", {
        className: "tqm-label"
      }, "Estimativa de acerto"), this.getPercentageInput('hit_estimate'))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        item: true,
        sm: 12,
        lg: 3,
        className: "pr-5 mt-3"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("label", {
        className: "tqm-label"
      }, "Custos externos"), this.getMoneyInput('external_costs'), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "mt-3"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("label", {
        className: "tqm-label"
      }, "Custos internos"), this.getMoneyInput('internal_costs'))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        item: true,
        sm: 12,
        lg: 2,
        className: "mt-3"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("label", {
        className: "tqm-label pb-2"
      }, "ROI"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_currency_format__WEBPACK_IMPORTED_MODULE_3___default.a, {
        className: "font-gray",
        displayType: 'text',
        placeholder: "0",
        decimalScale: 2,
        fixedDecimalScale: true,
        value: this.calculateRoi()
      })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        item: true,
        sm: 12,
        lg: 4,
        className: "mt-3"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("label", {
        className: "tqm-label pb-0"
      }, "Descri\xE7\xE3o"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("textarea", {
        rows: 4,
        className: "form-control",
        onChange: this.handleChange.bind(this, 'description'),
        value: this.state.description
      })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        item: true,
        sm: 12,
        className: "mt-3 mb-3"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
        className: "title-badge"
      }, "A\xE7\xE3o")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "w-100",
        style: {
          overflowX: 'auto'
        }
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("table", {
        className: "table doi-table"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tr", {
        style: {
          borderBottom: '1px solid #CED4DA'
        }
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "160px",
        className: ""
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "400px",
        className: "text-center"
      }, "BASELINE"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "360px",
        className: "text-center"
      }, "INICIATIVA"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "400px",
        className: "text-center"
      }, "REDU\xC7\xC3O DE CUSTO")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tr", {
        style: {
          borderBottom: 'none'
        }
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "160px",
        className: ""
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("select", {
        value: this.state.item_type,
        onChange: this.handleChange.bind(this, 'item_type'),
        className: "form-control"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("option", null, "Selecionar"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("option", {
        value: 1
      }, "Material"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("option", {
        value: 2
      }, "Negocia\xE7\xE3o"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("option", {
        value: 3
      }, "Efici\xEAncia"))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "400px",
        className: "text-center px-1 pt-0"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12"
      }, "Custo or\xE7ado"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12"
      }, "Custo (atual)"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12"
      }, "Volume anual (hist\xF3rico)"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12"
      }, "Total / Ano")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "360px",
        className: "text-center px-1 pt-0"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "120px",
        className: "text-center font-12"
      }, "Custo (novo)"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "120px",
        className: "text-center font-12"
      }, "Volume anual (or\xE7amento)"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "120px",
        className: "text-center font-12"
      }, "Total / Ano")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "400px",
        className: "text-center px-1 pt-0"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12"
      }, "Redu\xE7\xE3o de custo / unid."), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12"
      }, "Custo evitado / unid."), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12"
      }, "Redu\xE7\xE3o de custo / aa"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12"
      }, "Custo evitado / aa"))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tr", {
        style: {
          borderTop: 'none'
        },
        className: ""
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "160px",
        style: {
          paddingTop: 20
        },
        className: "font-14"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "400px",
        className: "text-center px-1 pt-0"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12 pl-0 pr-1"
      }, this.getMoneyInput('baseline_1')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12 pl-0 pr-1"
      }, this.getMoneyInput('baseline_2')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12 pl-0 pr-1"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
        min: 0,
        placeholder: "100",
        className: "form-control",
        type: "number",
        value: this.state.baseline_3,
        onChange: this.handleChange.bind(this, 'baseline_3')
      })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12 pl-0 pr-1"
      }, this.getMoneyInput('baseline_4', true))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "360px",
        className: "text-center px-1 pt-0"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "120px",
        className: "text-center font-12 pl-0 pr-1"
      }, this.getMoneyInput('initiative_1')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "120px",
        className: "text-center font-12 pl-0 pr-1"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
        min: 0,
        placeholder: "100",
        className: "form-control",
        type: "number",
        value: this.state.initiative_2,
        onChange: this.handleChange.bind(this, 'initiative_2')
      })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "120px",
        className: "text-center font-12 pl-0 pr-1"
      }, this.getMoneyInput('initiative_3', true))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "400px",
        className: "text-center px-1 pt-0"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12 pl-0 pr-1"
      }, this.getMoneyInput('cost_reduction_1')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12 pl-0 pr-1"
      }, this.getMoneyInput('cost_reduction_2', this.state.item_type == 3)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12 pl-0 pr-1"
      }, this.getMoneyInput('cost_reduction_3')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: "text-center font-12 pl-0 pr-1"
      }, this.getMoneyInput('cost_reduction_4', this.state.item_type == 3))))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "font-blue font-14",
        style: {
          width: 1320,
          backgroundColor: '#FFF',
          borderRadius: 4,
          padding: '10px 0px'
        }
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        style: {
          width: 160
        },
        className: "font-14 pl-4 d-inline-block"
      }, this.getItemTypeText()), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        style: {
          width: 100
        },
        className: "text-center font-12 pl-1 pr-1 d-inline-block"
      }, this.getMoneyText(this.state.baseline_1)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        style: {
          width: 100
        },
        className: "text-center font-12 pl-0 pr-1 d-inline-block"
      }, this.getMoneyText(this.state.baseline_2)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        style: {
          width: 100
        },
        className: "text-center font-12 pl-0 pr-1 d-inline-block"
      }, this.state.baseline_3), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        style: {
          width: 100
        },
        className: "text-center font-12 pl-0 pr-1 d-inline-block"
      }, this.getMoneyText(this.state.baseline_4)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        style: {
          width: 120
        },
        className: "text-center font-12 pl-0 pr-1 d-inline-block"
      }, this.getMoneyText(this.state.initiative_1)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        style: {
          width: 120
        },
        className: "text-center font-12 pl-0 pr-1 d-inline-block"
      }, this.state.initiative_2 || 0), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        style: {
          width: 120
        },
        className: "text-center font-12 pl-0 pr-1 d-inline-block"
      }, this.getMoneyText(this.state.initiative_3)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        style: {
          width: 100
        },
        className: "text-center font-12 pl-0 pr-1 d-inline-block"
      }, this.getMoneyText(this.state.cost_reduction_1)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        style: {
          width: 100
        },
        className: "text-center font-12 pl-0 pr-1 d-inline-block"
      }, this.state.item_type == 3 ? '-' : this.getMoneyText(this.state.cost_reduction_2)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        style: {
          width: 100
        },
        className: "text-center font-12 pl-0 pr-1 d-inline-block"
      }, this.getMoneyText(this.state.cost_reduction_3)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        style: {
          width: 100
        },
        className: "text-center font-12 pl-0 pr-1 d-inline-block"
      }, this.state.item_type == 3 ? '-' : this.getMoneyText(this.state.cost_reduction_4)))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        item: true,
        sm: 12,
        className: "mt-4 mb-2"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
        className: "title-badge"
      }, "Raz\xF5es para a adequa\xE7\xE3o")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        item: true,
        sm: 12,
        className: "mb-3"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("textarea", {
        rows: 3,
        className: "form-control",
        value: this.state.reasons_description,
        onChange: this.handleChange.bind(this, 'reasons_description')
      })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        item: true,
        sm: 12,
        className: "mt-4"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
        onClick: this.handleSave.bind(this),
        className: "btn btn-tqm d-inline-block mr-2"
      }, "Salvar informa\xE7\xF5es"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", {
        className: "btn btn-discard",
        href: "/doi"
      }, "Descartar informa\xE7\xF5es")));
    }
  }]);

  return FinancialForm;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component);


/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./assets/js/react/renderers/FinancialFormRender.js":
/*!**********************************************************!*\
  !*** ./assets/js/react/renderers/FinancialFormRender.js ***!
  \**********************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_FinancialForm__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../components/FinancialForm */ "./assets/js/react/components/FinancialForm.js");



react_dom__WEBPACK_IMPORTED_MODULE_1___default.a.render( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_components_FinancialForm__WEBPACK_IMPORTED_MODULE_2__["default"], null), document.getElementsByClassName('react-component')[0]);
document.getElementsByClassName('react-component')[0].classList.remove('hide');

/***/ })

},[["./assets/js/react/renderers/FinancialFormRender.js","runtime","vendors~app~co~doi_form~financial_form~grd-dashboard~img-dropzone~jquery-mask~jquery-money-mask~menu~40356eb1","vendors~client_form~dashboard~doi_form~financial_form~multiple_select","vendors~client_form~dashboard~doi_form~financial_form","vendors~app~doi_form~financial_form","vendors~doi_form~financial_form","doi_form~financial_form"]]]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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