(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["doi_form"],{

/***/ "./assets/js/react/components/DoiForm.js":
/*!***********************************************!*\
  !*** ./assets/js/react/components/DoiForm.js ***!
  \***********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function($) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DoiForm; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "./node_modules/@material-ui/core/esm/index.js");
/* harmony import */ var _shared_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../shared/styles */ "./assets/js/react/shared/styles.js");
/* harmony import */ var react_currency_format__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-currency-format */ "./node_modules/react-currency-format/lib/currency-format.js");
/* harmony import */ var react_currency_format__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_currency_format__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_datepicker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-datepicker */ "./node_modules/react-datepicker/dist/react-datepicker.min.js");
/* harmony import */ var react_datepicker__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_datepicker__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var date_fns_locale_pt_BR__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! date-fns/locale/pt-BR */ "./node_modules/date-fns/esm/locale/pt-BR/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! moment */ "./node_modules/moment/moment.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _cute_alert_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../cute-alert.js */ "./assets/js/cute-alert.js");
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }









Object(react_datepicker__WEBPACK_IMPORTED_MODULE_4__["registerLocale"])('pt', date_fns_locale_pt_BR__WEBPACK_IMPORTED_MODULE_5__["default"]);


var DoiForm = /*#__PURE__*/function (_React$Component) {
  _inherits(DoiForm, _React$Component);

  var _super = _createSuper(DoiForm);

  function DoiForm(props) {
    var _this;

    _classCallCheck(this, DoiForm);

    _this = _super.call(this, props);
    _this.state = window.props.doi || {};
    _this.state.users = window.props.users || [];
    _this.state.current_user = window.props.current_user;
    _this.state.items = (window.props.items || []).map(function (x) {
      x.start = x.start ? new Date(x.start) : x.start;
      x.deadline = x.deadline ? new Date(x.deadline) : x.deadline;
      x.revised_date = x.revised_date ? new Date(x.revised_date) : x.revised_date;
      return x;
    });
    return _this;
  }

  _createClass(DoiForm, [{
    key: "handleChange",
    value: function handleChange(attr, item, event) {
      var value = _typeof(event) === 'object' && event.target ? event.target.value : event;

      if (item) {
        if (attr === 'revised_date') {
          if (item.deadline && moment__WEBPACK_IMPORTED_MODULE_7___default()(value) > moment__WEBPACK_IMPORTED_MODULE_7___default()(item.deadline)) {
            this.handleChange('modal_date_open', false, item);
          }
        }

        var validateDate = false;
        var items = this.state.items.map(function (x) {
          if (true === validateDate) {
            if (item.start > x.start || item.deadline > x.start) {
              x.start = null;
            }

            if (item.start > x.deadline || item.deadline > x.deadline) {
              x.deadline = null;
            }
          }

          if (x.id == item.id) {
            x[attr] = value;
            validateDate = true;

            if (x.start > x.deadline) {
              x.deadline = null;
            }
          }

          return x;
        });
        this.setState({
          items: items
        });
      } else {
        this.setState(_defineProperty({}, attr, value));
      }
    }
  }, {
    key: "cancel",
    value: function cancel(item) {
      this.handleChange('canceled', item, true);
      this.handleChange('modal_open', false, false);
    }
  }, {
    key: "confirm",
    value: function confirm(item) {
      this.handleChange('approved', item, true);
    }
  }, {
    key: "handleConfirm",
    value: function handleConfirm(item) {
      var _this2 = this;

      Object(_cute_alert_js__WEBPACK_IMPORTED_MODULE_8__["default"])({
        type: 'question',
        title: 'Confirmar datas',
        message: 'Deseja confirmar as datas desta etapa?',
        confirmText: 'Sim',
        cancelText: 'Não'
      });
      setTimeout(function () {
        $('.cute-alert-confirm').off();
        $('.cute-alert-confirm').on('click', _this2.confirm.bind(_this2, item));
      }, 500);
    }
  }, {
    key: "handleCancel",
    value: function handleCancel(item) {
      var _this3 = this;

      Object(_cute_alert_js__WEBPACK_IMPORTED_MODULE_8__["default"])({
        type: 'question',
        title: 'Desativar iniciativa',
        message: 'Tem certeza que deseja desativar esta iniciativa?',
        cancelText: 'Não',
        confirmText: 'Desativar e Notificar'
      });
      setTimeout(function () {
        $('.cute-alert-confirm').off();
        $('.cute-alert-confirm').on('click', _this3.handleChange.bind(_this3, 'modal_open', false, item));
      }, 500);
    }
  }, {
    key: "handleSave",
    value: function handleSave() {
      var data = this.state.items;
      axios__WEBPACK_IMPORTED_MODULE_6___default()({
        url: '/doi/new',
        method: 'post',
        data: data
      }).then(function (res) {
        if (res.data.success) {
          Object(_cute_alert_js__WEBPACK_IMPORTED_MODULE_8__["default"])({
            type: 'success',
            title: 'Dados salvos',
            message: 'Dados salvos com sucesso!'
          });
        }
      });
    }
  }, {
    key: "getElapsedTime",
    value: function getElapsedTime(item) {
      if (!item.start || !item.deadline) {
        return 0;
      }

      var now = moment__WEBPACK_IMPORTED_MODULE_7___default()(new Date());
      var start = moment__WEBPACK_IMPORTED_MODULE_7___default()(item.start);
      var end = moment__WEBPACK_IMPORTED_MODULE_7___default()(item.deadline);
      var duration = moment__WEBPACK_IMPORTED_MODULE_7___default.a.duration(end.diff(start));
      var duration_now = moment__WEBPACK_IMPORTED_MODULE_7___default.a.duration(now.diff(start));
      var hours = duration.asHours();
      var hours_now = duration_now.asHours();
      var percent = Math.round(100 / hours * hours_now);

      if (typeof percent != 'number') {
        return 0;
      } else if (percent >= 100) {
        return 100;
      } else if (percent <= 0) {
        return 0;
      } else {
        return percent;
      }
    }
  }, {
    key: "getItems",
    value: function getItems() {
      var _this4 = this;

      var dateProps = {
        className: "form-control",
        locale: date_fns_locale_pt_BR__WEBPACK_IMPORTED_MODULE_5__["default"],
        dateFormat: "dd/MM/yyyy"
      };
      var canceled = false;
      var last_item;
      return this.state.items.map(function (item) {
        if (item.canceled) {
          canceled = true;
        }

        var colorBall;

        if (null !== item.status_percent && item.status_percent >= 100) {
          colorBall = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
            className: "ml-1 mr-1 circle-green"
          }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
            className: "mr-1 circle-gray"
          }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
            className: "circle-gray"
          }));
        } else if (null !== item.deadline && item.status_percent < 100 && new Date(item.deadline).getTime() < Date.now()) {
          colorBall = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
            className: "ml-1 mr-1 circle-gray"
          }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
            className: "mr-1 circle-gray"
          }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
            className: "circle-red"
          }));
        } else {
          colorBall = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
            className: "ml-1 mr-1 circle-gray"
          }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
            className: "mr-1 circle-yellow"
          }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
            className: "circle-gray"
          }));
        }

        var row = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tr", {
          key: "item-".concat(item.id)
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", {
          width: "100px"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", null, colorBall)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", {
          width: "120px"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", null, item.stage_name)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", {
          width: "140px"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", null, item.responsible_name && item.responsible_name)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", {
          width: "140px"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_datepicker__WEBPACK_IMPORTED_MODULE_4___default.a, _extends({
          disabled: item.approved
        }, dateProps, {
          minDate: last_item ? last_item.deadline ? last_item.deadline : last_item.start : null,
          selected: item.start,
          onChange: _this4.handleChange.bind(_this4, 'start', item)
        }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", {
          width: "140px"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_datepicker__WEBPACK_IMPORTED_MODULE_4___default.a, _extends({
          disabled: item.approved,
          minDate: item.start ? item.start : last_item ? last_item.deadline ? last_item.deadline : last_item.start : null
        }, dateProps, {
          selected: item.deadline,
          onChange: _this4.handleChange.bind(_this4, 'deadline', item)
        }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", {
          width: "165px",
          className: "pr-0"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
          className: "ml-1 " + (item.revised_date ? " w-85 " : " w-100 ") + (item.status_percent >= 100 || item.deadline && new Date(item.deadline).getTime() > Date.now() ? " d-none " : "d-inline-block")
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_datepicker__WEBPACK_IMPORTED_MODULE_4___default.a, _extends({}, dateProps, {
          minDate: last_item ? last_item.revised_date : undefined,
          selected: item.revised_date,
          onChange: _this4.handleChange.bind(_this4, 'revised_date', item)
        }))), item.revised_date && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("i", {
          title: item.deadline_explain ? 'Motivo do atraso: ' + item.deadline_explain : '',
          style: {
            marginTop: 12
          },
          className: "fas c-pointer fa-clock d-inline-block ml-1"
        })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", {
          width: "100px"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", null, _this4.getElapsedTime(item), "%")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", {
          width: "100px"
        }, _this4.state.edit_percent == item.id ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
          type: "number",
          max: "100",
          min: "0",
          autoFocus: true,
          onClick: _this4.handleChange.bind(_this4, 'edit_percent', false, false),
          className: "status-percent form-control",
          value: item.status_percent,
          onChange: _this4.handleChange.bind(_this4, 'status_percent', item)
        }) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
          onClick: _this4.handleChange.bind(_this4, 'edit_percent', false, item.id)
        }, (item.status_percent || '0') + '%')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", {
          width: "140px"
        }, item.stage < 4 ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", null, item.responsible_name && item.responsible_name) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("select", {
          onChange: _this4.handleChange.bind(_this4, 'responsible', item),
          value: item.responsible,
          className: "form-control"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("option", null), _this4.state.users.map(function (x) {
          return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("option", {
            key: x.id,
            value: x.id
          }, x.name);
        }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", {
          width: "140px"
        }, item.canceled && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
          className: "c-pointer d-inline-block font-red"
        }, "Cancelado"), item.approved && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
          className: "c-pointer d-inline-block font-green"
        }, "Confirmado"), !canceled && _this4.state.current_user == item.responsible && !item.approved && !item.canceled && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
          onClick: item.status_percent != 100 ? null : _this4.handleConfirm.bind(_this4, item),
          className: "d-inline-block " + (item.status_percent != 100 ? "font-gray" : "c-pointer font-green")
        }, "Confirmar"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("i", {
          onClick: _this4.handleCancel.bind(_this4, item),
          className: "c-pointer fas fa-trash-alt d-inline-block ml-3"
        }))));

        if (item.start || item.deadline || item.revised_date) {
          last_item = item;
        }

        return row;
      });
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "pr-0",
        style: {
          overflowX: 'auto'
        }
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("table", {
        className: "table doi-table w-100 pr-0"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("thead", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tr", {
        className: ""
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: ""
      }, "GERAL"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "120px",
        className: ""
      }, "DOI"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "140px",
        className: ""
      }, "RESPONS\xC1VEL"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "140px",
        className: ""
      }, "IN\xCDCIO"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "140px",
        className: ""
      }, "PRAZO PLANEJADO"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "165px",
        className: ""
      }, "DATA REVISADA"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: ""
      }, "TEMPO DECORRIDO"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "100px",
        className: ""
      }, "STATUS DE CONCLUS\xC3O"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "140px",
        className: ""
      }, "RESPONS\xC1VEL PELA APROVA\xC7\xC3O"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", {
        width: "120px",
        className: ""
      }, "APROVA\xC7\xD5ES"))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tbody", null, this.getItems())), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Modal"], {
        onClose: this.handleChange.bind(this, this.state.modal_open ? 'modal_open' : 'modal_date_open', false, false),
        open: !!this.state.modal_open || !!this.state.modal_date_open
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "tqm-modal-body"
      }, this.state.modal_open && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
        className: "mt-2 mb-2 font-16 tqm-label text-center"
      }, "Por que esta iniciativa est\xE1 sendo desativada?"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("textarea", {
        className: "form-control",
        onChange: this.handleChange.bind(this, 'cancel_explain', this.state.modal_open),
        placeholder: "Explique por qual motivo sua iniciativa est\xE1 sendo desativada"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
        onClick: this.cancel.bind(this, this.state.modal_open),
        className: "btn btn-tqm mt-3 d-inline-block"
      }, "Desativar"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
        onClick: this.handleChange.bind(this, 'modal_open', false, false),
        className: "btn btn-tqm-outline mt-3 ml-3 d-inline-block"
      }, "Cancelar")), this.state.modal_date_open && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
        className: "mt-2 mb-2 font-16 tqm-label text-center"
      }, "Motivo do atraso"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("textarea", {
        className: "form-control",
        onChange: this.handleChange.bind(this, 'deadline_explain', this.state.modal_date_open),
        placeholder: "Explique por qual motivo sua entrega atrasou"
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
        onClick: this.handleChange.bind(this, 'modal_date_open', false, false),
        className: "btn btn-tqm mt-3 d-inline-block"
      }, "Ok")))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        container: true,
        className: "mt-4 ml-4 pb-3"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["Grid"], {
        item: true,
        sm: 12
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
        onClick: this.handleSave.bind(this),
        className: "btn btn-tqm d-inline-block mr-2"
      }, "Salvar e Notificar"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", {
        className: "btn btn-discard",
        href: "/doi"
      }, "Descartar informa\xE7\xF5es"))));
    }
  }]);

  return DoiForm;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component);


/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./assets/js/react/renderers/DoiFormRender.js":
/*!****************************************************!*\
  !*** ./assets/js/react/renderers/DoiFormRender.js ***!
  \****************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_DoiForm__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../components/DoiForm */ "./assets/js/react/components/DoiForm.js");



react_dom__WEBPACK_IMPORTED_MODULE_1___default.a.render( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_components_DoiForm__WEBPACK_IMPORTED_MODULE_2__["default"], null), document.getElementsByClassName('react-component')[0]);
document.getElementsByClassName('react-component')[0].classList.remove('hide');

/***/ })

},[["./assets/js/react/renderers/DoiFormRender.js","runtime","vendors~app~co~doi_form~financial_form~grd-dashboard~img-dropzone~jquery-mask~jquery-money-mask~menu~40356eb1","vendors~client_form~dashboard~doi_form~financial_form~multiple_select","vendors~client_form~dashboard~doi_form~financial_form","vendors~app~doi_form~financial_form","vendors~doi_form~financial_form","doi_form~financial_form"]]]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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